#!/bin/bash
#SBATCH --job-name=MNIST-DDPM # name of the job
#SBATCH -p gpu-unlimited # which partition the job should be scheduled on
#SBATCH --output=./slurm_logs/MNIST-DDPM-%j.out
#SBATCH --error=./slurm_logs/MNIST-DDPM-%j.err
#SBATCH --nodes=4
#SBATCH --tasks-per-node=12
##SBATCH -w gpu[29,30,31,33]
##SBATCH --mem=3000
##SBATCH -N 5
##SBATCH -a 0-120%3

dt=$(date '+%d/%m/%Y %H:%M:%S');
echo $dt # debugging datetime print

## generate samples of single diffusion model
python3 generate_samples.py --epoch $1 --model_file 'models/infimnist/ddpm/setid{}_frac1.0/model_ep{}.pth' --save_folder 'models/infimnist/ddpm/generated_frac1.0/'
##python3 generate_samples.py --epoch $1 --model_file 'models/infimnist/ddpm/setid{}_frac0.01/model_ep{}.pth' --save_folder 'models/infimnist/ddpm/generated_frac0.01/'
	
dt=$(date '+%d/%m/%Y %H:%M:%S');
echo $dt # debugging datetime print
